#
# Python Imaging Library
# $Id$
#
# display OLE document summary information
#

import sys
from OleFileIO import *

summary_props = [
    ("Title", 2),
    ("Subject", 3),
    ("Author", 4),
    ("Keywords", 5),
    ("Comments", 6),
    ("Template", 7),
    ("Last saved by", 8),
    ("Revision number", 9),
    ("Total editing time", 10),
    ("Last printed", 11),
    ("Create time/date", 12),
    ("Last saved time/date", 13),
    ("Number of Pages", 14),
    ("Number of Words", 15),
    ("Number of characters", 16),
#    ("Thumbnail", 17), # this is a clipboard blob!
    ("Name of creating application", 18),
    ("Security", 19)
]

def summary(ole):

    props = ole.getproperties(["\005SummaryInformation"])

    for name, id in summary_props:
	try:
	    value = props[id]
	    print "%s: %s" % (name, value)
	except KeyError:
	    pass

# --------------------------------------------------------------------
# main

for file in sys.argv[1:]:
    try:
	ole = OleFileIO(file)
	print "-" * 68
	print file
	print "-" * 68
	summary(ole)
    except IOError:
	pass
