////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:23
//  it subclasses all classes of the unit ExtCtrls
////

unit Delphi_ExtCtrls;

interface

uses
  Messages,
  Windows,
  SysUtils,
  Classes,
  Controls,
  Forms,
  Menus,
  Graphics,
  StdCtrls,
  ExtCtrls,
  PythonEngine,
  PyVarArg,
  PyRecords,
  PyDelphiAssoc;

type
  TPyShape = class( TShape )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyPaintBox = class( TPaintBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnPaint( Sender : TObject );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyImage = class( TImage )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnProgress( Sender : TObject; Stage : TProgressStage; PercentDone : Byte; RedrawNow : Boolean; const R : TRect; const Msg : string );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyBevel = class( TBevel )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyTimer = class( TTimer )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnTimer( Sender : TObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomPanel = class( TCustomPanel )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyPanel = class( TPanel )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnResize( Sender : TObject );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyPage = class( TPage )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyNotebook = class( TNotebook )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnPageChanged( Sender : TObject );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyHeader = class( THeader )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnSizing( Sender : TObject; ASection, AWidth : Integer );
    procedure EventOnSized( Sender : TObject; ASection, AWidth : Integer );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomRadioGroup = class( TCustomRadioGroup )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyRadioGroup = class( TRadioGroup )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPySplitter = class( TSplitter )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnMoved( Sender : TObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;


implementation

Uses Py_Misc;

/////////// class TPyShape /////////////////////

destructor TPyShape.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyShape.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyShape.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyShape.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonObject( Target, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyShape.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyShape.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyShape.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyShape.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TShape' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'ExtCtrls', 'TShape' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyPaintBox /////////////////////

destructor TPyPaintBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyPaintBox.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonObject( Target, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnPaint( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    rslt := ExecuteEvent( 'OnPaint', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPaintBox.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPaintBox' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'ExtCtrls', 'TPaintBox' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyImage /////////////////////

destructor TPyImage.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyImage.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonObject( Target, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnProgress( Sender : TObject; Stage : TProgressStage; PercentDone : Byte; RedrawNow : Boolean; const R : TRect; const Msg : string );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Stage) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( PercentDone ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( RedrawNow ) ); 
    L.Add( CreateRect( R ).GetSelf ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Msg ) ); 
    rslt := ExecuteEvent( 'OnProgress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyImage.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TImage' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'ExtCtrls', 'TImage' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyBevel /////////////////////

destructor TPyBevel.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyTimer /////////////////////

destructor TPyTimer.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyTimer.EventOnTimer( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TTimer' ) ); 
    rslt := ExecuteEvent( 'OnTimer', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomPanel /////////////////////

destructor TPyCustomPanel.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyPanel /////////////////////

destructor TPyPanel.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyPanel.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonObject( Target, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnResize( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    rslt := ExecuteEvent( 'OnResize', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyPanel.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TPanel' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'ExtCtrls', 'TPanel' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyPage /////////////////////

destructor TPyPage.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyNotebook /////////////////////

destructor TPyNotebook.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyNotebook.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonObject( Target, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnPageChanged( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    rslt := ExecuteEvent( 'OnPageChanged', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyNotebook.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TNotebook' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'ExtCtrls', 'TNotebook' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyHeader /////////////////////

destructor TPyHeader.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyHeader.EventOnSizing( Sender : TObject; ASection, AWidth : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'THeader' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( ASection ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( AWidth ) ); 
    rslt := ExecuteEvent( 'OnSizing', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyHeader.EventOnSized( Sender : TObject; ASection, AWidth : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'THeader' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( ASection ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( AWidth ) ); 
    rslt := ExecuteEvent( 'OnSized', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomRadioGroup /////////////////////

destructor TPyCustomRadioGroup.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyRadioGroup /////////////////////

destructor TPyRadioGroup.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyRadioGroup.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioGroup.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioGroup.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( GetPythonObject( Source, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioGroup.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( GetPythonObject( Target, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioGroup.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioGroup.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioGroup.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TRadioGroup' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'ExtCtrls', 'TRadioGroup' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPySplitter /////////////////////

destructor TPySplitter.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPySplitter.EventOnMoved( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'ExtCtrls', 'TSplitter' ) ); 
    rslt := ExecuteEvent( 'OnMoved', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;


end.
